<?php



namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Booking;

use App\Mail\BookingAHotel;

use Mail;

class BookingController extends Controller

{



    public function store(Request $request){

        $this->validate($request, [
            'car_name' => 'required',
            'check_in' => 'required',
            //'check_out' => 'required',
            'pick_up' => 'required',
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
        ]);

        

        $booking = new Booking();

        $booking->car_name = $request->car_name;
        $booking->pick_up = $request->pick_up;

        $booking->pick_up_datetime = $request->pick_up_datetime;
        $booking->drop_off_datetime = $request->drop_off_datetime;

        $booking->name = $request->name;

        $booking->email = $request->email;

        $booking->phone = $request->phone;

        $booking->type = $request->type;

        $booking->trip_type = $request->trip_type;

        $booking->check_in = $request->check_in;

        $booking->check_out = $request->check_out;

        $booking->adults = $request->adults;

        $booking->childrens = $request->childrens;

        $booking->rooms = $request->rooms;

        $booking->save();



        Mail::send(new BookingAHotel($booking));
        $request->session()->flash('message.added', 'success');
        $request->session()->flash('message.content', 'Your form is successfully submitted');
        return redirect()->back();

    }  

}

