<?php







namespace App\Http\Controllers;



use App\Http\Controllers\Controller;



use Illuminate\Http\Request;



use App\Models\ModulesData;



use App\Models\Tags;







class FlightsController extends Controller



{



    public function index(Request $request){

        $data = ModulesData::where('module_id', 10)->where('status','active');





        if ($request->has('location')) {

            $data->where('extra_field_7', 'like', '%'.$request->location.'%');

        }

        if ($request->has('flight_to')) {

            $data->where('extra_field_8', 'like', '%'.$request->flight_to.'%');

        }







        if ($request->has('category')) {

            $data->where('category', $request->category);

        }







        if ($request->has('archive')) {

            $data->whereMonth('created_at', date('m', strtotime($request->archive)))->whereYear('created_at', date('Y', strtotime($request->archive)));

        }







        if ($request->has('tag')) {

            $data->whereRaw("FIND_IN_SET($request->tag,tag_ids)");

        }







        if ($request->has('cate')) {

            $data->whereRaw("FIND_IN_SET($request->cate,category_ids)");

        }

		

		

        $arr['flights'] = $data->paginate(10);

        $arr['recent_data'] = ModulesData::where('module_id', 10)->where('status','active')->orderBy('id','desc')->take(3)->get();

        $arr['archives'] = $this->lastThreeMonths();

        return view('flights.index')->with($arr);



    }   







    public function detail($slug){

    	$data['flights'] = ModulesData::where('slug',trim($slug))

    	 		->where('module_id', 10)

    	 		->where('status','active')

    	 		->first();

    	$data['recent_data'] = ModulesData::where('module_id', 10)->where('id','!=',$data['flights']->id)->where('status','active')->orderBy('id','desc')->take(10)->get(); 

    	$tag_ids = explode(',', $data['flights']->tag_ids);

    	$data['tags'] = Tags::where('status','active')->whereIn('id', $tag_ids)->get();	

		$data['archives'] = $this->lastThreeMonths();  

    	return view('flights.detail')->with($data); 	

    }







    function lastThreeMonths() {

	    return array(

	        date('F Y', time()),

	        date('F Y', strtotime('-1 month')),

	        date('F Y', strtotime('-2 month'))

	    );



	}



}



