@extends('layouts.app')

@section('content')

<!-- Inner Heading Start -->



<div class="pageTitle flightbg">

  <div class="container">

    

        <h1 class="page-heading">@if(isset(request()->keyword))

         {{request()->keyword}}

         @else

         {{__('All Flights')}}

         @endif</h1>

      

  </div>

</div>

<!-- Inner Heading End --> 

<!-- Inner Content Start -->

<div class="innercms">

  <div class="container"> 

    <h2>{{__('Choose your Preffer Flight')}}</h2>

    <!-- Blog start -->

    <div class="destinationList">

      

          @if(null!==($flights))

          <ul class="flightslist">

           @foreach($flights as $flight) 
			<li>
          <div class="locwrap row">
			  <div class="col-lg-4"><div class="imgbox"><a href="{{asset('images/'.$flight->image)}}" class="image-popup"><img src="{{asset('images/'.$flight->image)}}" alt="" /></a></div></div>
			  <div class="col-lg-5">
			  <h3>{{$flight->title}}</h3>
            <div class="location"><i class="fa fa-calendar" aria-hidden="true"></i> {{$flight->extra_field_9}} - {{$flight->extra_field_10}}</div>
			  <div class="prices"><span>{{__('Price From')}}</span> {{$flight->extra_field_1}}</div>
            <div class="meta">
				<span title="{{__('Airline')}}"><i class="fas fa-plane"></i> <strong>{{$flight->extra_field_2}}</strong></span>
				<span title="{{__('Flight Type')}}"><i class="fa fa-users" aria-hidden="true"></i> <strong>{{$flight->extra_field_3}}</strong></span>
				<span title="{{__('From')}}"><i class="fas fa-plane-departure"></i> <strong>{{$flight->extra_field_7}}</strong></span>
			  <span title="{{__('To')}}"><i class="fas fa-plane-arrival"></i> <strong>{{$flight->extra_field_8}}</strong></span>
			  </div>
			  
			  </div>
			  <div class="col-lg-3"><div class="buttons"><a href="{{route('flights.detail',$flight->slug)}}" class="btn"><i class="fa fa-calendar" aria-hidden="true"></i> {{__('View Details')}} </a></div></div>
			              
          </div>	
        </li>		

            @endforeach

          </ul>

          @endif

          

        </div>

        

        <!-- Pagination -->

        <div class="pagiWrap">

            <div class="row">

               <div class="col-md-5">

                  <div class="showreslt">

                     {{__('Showing Results')}} : {{ $flights->firstItem() }} - {{ $flights->lastItem() }} {{__('Total')}} {{ $flights->total() }}

                  </div>

               </div>

               <div class="col-md-7 text-right">

                  @if(isset($flights) && count($flights))

                  {{ $flights->appends(request()->query())->links() }}

                  @endif

               </div>

            </div> 

          </div>

        </div>

      

    </div>







<!-- Inner Content Start --> 

@endsection


