@extends('layouts.app')

@section('content')



<!-- Page Title start -->

<div class="pageTitle hotelsbg">

  <div class="container">

        <h1 class="page-heading">{{__('Hotel Detail')}}</h1>

  </div>

</div>



<?php 

	$cate_ids = explode(",", $hotels->category_ids);



	$categories = App\Models\ModulesData::whereIn('id', $cate_ids)->where('status','active')->get();

  $cate_array = array();

  foreach ($categories as $cat) {

	  $cate_array[] = "<a href='" . route('hotels.list','cate='.$cat->id) . "'>$cat->title</a>";

  }  

?>







<!-- Page Title End -->







<div class="innercms">







  <div class="container"> 

	  

	<div class="hotelmaininfo">

    <div class="row">

			<div class="col-md-8">

				<h1>{{$hotels->title}}</h1>

				<div class="location"><i class="fas fa-map-marker-alt" aria-hidden="true"></i> {{$hotels->extra_field_10}}</div>

				<div class="date">{{__('Added On')}}: {{date('M d, Y',strtotime($hotels->created_at))}}</div>

			</div>  

			<div class="col-md-4"><div class="prices"><span>{{__('Price From')}}</span> {{$hotels->extra_field_1}}</div></div>  

		</div>

	 </div> 

	  

	  

    <div class="row">

      <div class="col-md-8"> 



        <!-- hotels List start -->

		



        <div class="hotelsWraper">

          <div class="hotelsList hotelsdetailbox">			  

		<div class="detailimages owl-carousel">

        @if($hotels->images!='')  

        <?php $images = explode(',', $hotels->images); ?>

        @if(null!==($images))

        @foreach($images as $img)

          <div class="item"><a href="{{asset('images/'.$img)}}" class="image-popup"><img src="{{asset('images/'.$img)}}" alt="" /></a></div>



        @endforeach

        @endif

        @endif

		</div>  

			  

    		<div class="descriptiondet">

            {!!removeTags($hotels->description)!!}  

			</div>

			  

			  

          </div>

        </div>

      </div>







      <div class="col-md-4"> 

		  	<div class="booknow"><a href="javascript:;" onclick="reserve('{{$hotels->title}}')">{{__('Book Hotel Now')}}</a></div>

		  

		  

			<div class="hotelsidebar">

				<h3>{{__('Hotel Details')}} </h3>

		  		<ul>

					<li>{{__('Price')}}: <strong>{{$hotels->extra_field_1}}</strong></li>

					<li>{{__('Hotel Type')}}: <strong>{{$hotels->extra_field_2}}</strong></li>

					<li>{{__('Room Type')}}: <strong>{{$hotels->extra_field_3}}</strong></li>

					<li>{{__('TV')}}: <strong>{{$hotels->extra_field_4}}</strong></li>

					<li>{{__('Internet')}}: <strong>{{$hotels->extra_field_5}}</strong></li>

					<li>{{__('Room Service')}}: <strong>{{$hotels->extra_field_6}}</strong></li>

					<li>{{__('Bar')}}: <strong>{{$hotels->extra_field_7}}</strong></li>

					<li>{{__('Gym')}}: <strong>{{$hotels->extra_field_8}}</strong></li>

					<li>{{__('Transport')}}: <strong>{{$hotels->extra_field_9}}</strong></li>

					<li>{{__('Location')}}: <strong>{{$hotels->extra_field_10}}</strong></li>

					<li>{{__('People')}}: <strong>{{$hotels->extra_field_11}}</strong></li>

				</ul>

				

		  	</div>

		  

		  

		 

		  

		  

		  

		  <div class="helpbox">

				<h4>{{__('Need Help')}}?</h4>

				<p>{{__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua')}}</p>

				<div class="phone"><i class="fas fa-phone-alt"></i> {{widget(1)->extra_field_3}}</div>

				<div class="phone"><i class="fas fa-envelope"></i> {{widget(1)->extra_field_2}}</div>

			</div>

		  

		  

		  



      </div>







    </div>





	  <hr>

	  

	  @if(null!==($recent_data)) 

           <div class="destinationList">

			  <h5 class="widget-title">{{__('Popular Hotels')}}</h5>

             <ul class="hotelslist row">

               @foreach($recent_data as $recent)

             				

			<li class="col-lg-4 col-md-6">

          <div class="locwrap">

            <div class="imgbox"><a href="{{asset('images/'.$recent->image)}}" class="image-popup"><img src="{{asset('images/'.$recent->image)}}" alt="" /></a></div>

            <h3>{{$recent->title}}</h3>

            <div class="location"><i class="fa fa-map-marker" aria-hidden="true"></i> {{$recent->extra_field_10}}</div>

			  <div class="prices"><span>{{__('Price')}}</span> {{$recent->extra_field_1}}</div>

            <div class="meta">

				<span title="{{__('Hotel Type')}}"><i class="fa fa-hotel" aria-hidden="true"></i> <strong>{{$recent->extra_field_2}}</strong></span>

				<span title="{{__('People')}}"><i class="fa fa-users" aria-hidden="true"></i> <strong>{{$recent->extra_field_11}}</strong></span>

				<span title="{{__('Room Type')}}"><i class="fa fa-bed" aria-hidden="true"></i> <strong>{{$recent->extra_field_3}}</strong></span></div>

            

            <div class="buttons"><a href="{{route('hotels.detail',$recent->slug)}}" class="btn"><i class="fa fa-calendar" aria-hidden="true"></i> {{__('View Details')}} </a></div>

          </div>	

        </li>	

				

				

				

				

              @endforeach

            </ul>

          </div>

          @endif

	  

	  

	  

	  

	  



  </div>







</div>







<!-- Inner Heading End --> 







<!-- Inner Content Start -->















<!-- Inner Content Start --> 







<!-- Inner Content Start --> 







<!-- Modal -->



<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">



  <div class="modal-dialog modal-xl" role="document">



    <div class="modal-content">



      <div class="modal-header">



        <h5 class="modal-title" id="exampleModalLabel">{{__('Hotel Booking Form')}}</h5>



        <button type="button" class="close" data-dismiss="modal" aria-label="Close">



          <span aria-hidden="true">&times;</span>



        </button>



      </div>



      <div class="modal-body">



        <div class="container">



  <div class="bformBox carbookext">



    <h3>{{__('Book Your Holiday Destination')}}</h3>



    <form action="{{route('booking.post')}}" method="POST">
      @csrf

      <input type="hidden" class="form-control" placeholder="{{__('Your Name')}}" name="type" value="hotel" >

      <div class="formrow">

		<label>{{__('Your Selected Hotel')}}</label>

        {!! Form::select('car_name', [''=>'Select Your Hotel For Booking']+dataArray(5), null, array('class'=>'form-control', 'id'=>'car_name', 'required'=>'required')) !!}



        {!! APFrmErrHelp::showErrors($errors, 'car_name') !!}



      </div>



      <div class="row">

		

		<div class="col-md-4 col-sm-4">



          <div class="formrow">

			<label>{{__('Your Name')}}</label>

            <input type="text" class="form-control" placeholder="{{__('Your Name')}}" name="name" required >



          </div>



        </div>



        <div class="col-md-4 col-sm-4">



          <div class="formrow">

			<label>{{__('Your Email')}}</label>

            <input type="email" class="form-control" placeholder="{{__('Your Email')}}" name="email" required>



          </div>



        </div>



        <div class="col-md-4 col-sm-4">



          <div class="formrow">

			<label>{{__('Phone')}}</label>

            <input type="text" class="form-control" placeholder="{{__('Phone')}}" name="phone" required>



          </div>



        </div>

		  

		  

        <div class="col-md-12">



          <div class="formrow">

			<label>{{__('Your Address')}}</label>

             <input type="text" class="form-control" name="pick_up" id="pick_up" placeholder="{{__('Your Address')}}" value="" required="required">

                      

          </div>



        </div>



        <div class="col-md-6 col-sm-6">
    <div class="formrow">
        <label>{{__('Check In')}}</label>
        <div class="input-group date form_datetime" data-date-format="dd MM yyyy - HH:ii p" data-link-field="dtp_input1">
            <input class="form-control" size="16" type="text" value="{{ now()->format('d M Y - H:i A') }}" placeholder="{{__('Select Date and Time')}}" name="check_in" required>
            <span class="input-group-addon"><i class="fas fa-calendar"></i></span>
        </div>
    </div>
</div>

<div class="col-md-6 col-sm-6">
    <div class="formrow">
        <label>{{__('Check Out')}}</label>
        <div class="input-group date form_datetime" data-date-format="dd MM yyyy - HH:ii p" data-link-field="dtp_input2">
            <input class="form-control" size="16" type="text" value="" placeholder="{{__('Select Date and Time')}}" name="check_out" required>
            <span class="input-group-addon"><i class="fas fa-calendar"></i></span>
        </div>
    </div>
</div>
		  

		 

		 <div class="col-md-4">

          <div class="formrow">

			<label>{{__('Adults')}}</label>

            <select name="adults" id="" class="form-control">

				<option value="1">1</option>  

				<option value="2">2</option>  

				<option value="3">3</option>  

				<option value="4">4</option>  

				<option value="5">5</option>  

				<option value="6">6</option>  

				<option value="7">7</option>  

				<option value="8">8</option>  

				<option value="9">9</option>  

				<option value="10">10</option>  

			</select>

          </div>

        </div>

		<div class="col-md-4">

          <div class="formrow">

			<label>{{__('Childrens')}}</label>

            <select name="childrens" id="" class="form-control">

				<option value="1">1</option>  

        <option value="2">2</option>  

        <option value="3">3</option>  

        <option value="4">4</option>  

        <option value="5">5</option>  

        <option value="6">6</option>  

        <option value="7">7</option>  

        <option value="8">8</option>  

        <option value="9">9</option>  

        <option value="10">10</option>  

			</select>

          </div>

        </div>

		<div class="col-md-4">

          <div class="formrow">

			<label>{{__('Room')}}</label>

            <select name="rooms" id="" class="form-control">

				<option value="Single">Single</option>  

				<option value="Double">Double</option>  

				<option value="Other">Other</option>   

			</select>

          </div>

        </div>  

		  

      </div>



      <div class="row">



       



        



      </div>



      <div class="row">



        



      </div>



      <div class="formbtn">



        <input type="submit" class="btn" value="Submit Your Booking">



      </div>



    </form>



  </div>



</div>



      </div>



    </div>



  </div>



</div>







<!-- Inner Content Start --> 



@endsection







@push('js')

<script type="text/javascript">
  function reserve(name) {
    $('#car_name').val(name);
    $('#exampleModal').modal('show');
  }
</script>

<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key={{widget(17)->extra_field_1}}&libraries=places"></script>

<script type="text/javascript" src="{{asset('js/cars.js')}}"></script>


<script>
    $(document).ready(function () {
        var currentDate = new Date();

        var checkInDatePicker = $('.form_datetime').eq(0).datetimepicker({
            format: 'dd MM yyyy - hh:ii p',
            minDate: currentDate,
            autoclose: true
        });

        var checkOutDatePicker = $('.form_datetime').eq(1).datetimepicker({
            format: 'dd MM yyyy - hh:ii p',
            minDate: currentDate,
            autoclose: true
        });

        checkInDatePicker.on('changeDate', function (selected) {
            // Set the minimum date for check-out as the selected check-in date + 1 minute
            var minDate = new Date(selected.date.getTime() + 60 * 1000);
            checkOutDatePicker.datetimepicker('setStartDate', minDate);
        });

        checkOutDatePicker.on('changeDate', function (selected) {
            // Set the maximum date for check-in as the selected check-out date - 1 minute
            var maxDate = new Date(selected.date.getTime() - 60 * 1000);
            checkInDatePicker.datetimepicker('setEndDate', maxDate);
        });
    });
</script>





@if(session()->has('message.added'))

<script type="text/javascript">

  var msg = '{!! session('message.content' )!!}';

</script>

<script type="text/javascript" src="{{asset('js/order.js')}}"></script>

@endif

@endpush