@extends('layouts.app')
@section('content')
<!-- Home Section -->
@if(widget(1)->radio_button_1==1)
<!-- Slider Section -->
<div class="tp-banner-container" id="slider">
  <div class="tp-banner">
    <ul> 
      @if(null!==(module(4))) 
      @foreach(module(4) as $slider) 
      <li data-slotamount="7" data-transition="fade" data-masterspeed="1000" data-saveperformance="on"> <img alt="" src="images/dummy.png" data-lazyload="{{asset('images/'.$slider->image)}}">
        <div class="caption lfb large-title tp-resizeme slidertext2" data-x="center" data-y="280" data-speed="600" data-start="1000">{{$slider->title}}</div>
        <div class="caption lfb large-title tp-resizeme slidertext1" data-x="center" data-y="310" data-speed="600" data-start="1600">{!!removeTags($slider->extra_field_1)!!}</div>
        <div class="caption lfb large-title tp-resizeme sliderbtn" data-x="center" data-y="400" data-speed="600" data-start="2200"><a href="{!!removeTags($slider->extra_field_3)!!}" class="section-btn">{!!removeTags($slider->extra_field_2)!!}</a></div>
      </li>
      @endforeach
      @endif
    </ul>
  </div>
</div>
<!-- Slider End -->
@else
<div id="home" class="parallax-section" style="background: url({{asset('images/'.widget(3)->extra_image_1)}}) no-repeat bottom;"> 
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <div class="slide-text">
          <h3>{{ widget(3)->extra_field_1 }} <a href="" class="typewrite" data-period="2000" data-type='[ "{{ widget(3)->extra_field_2 }}", "{{ widget(3)->extra_field_3 }}", "{{ widget(3)->extra_field_4 }}" ]'> <span class="wrap"></span> </a> </h3>
          <h1>{{ widget(3)->extra_field_5 }}</h1>
          <p>{{ widget(3)->description }}</p>
          <a href="{{ widget(3)->extra_field_7 }}" class="btn btn-default section-btn">{{ widget(3)->extra_field_6 }}</a> </div>
      </div>
    </div>
  </div>
</div>
@endif
<div class="bformBox nomr">
<div class="container">
<form action="{{route('hotels.list')}}" method="GET" id="search_form"> 
<div class="row">
	<div class="col-lg-3">
		<div class="formrow">
		<select id="search_type" class="form-control" required="required">
			<option value="">{{__('Please Select')}}</option>
			<option value="hotels">{{__('Hotels')}}</option>
			<option value="flights">{{__('Flights')}}</option>
		</select>
	</div>
	</div>
	<div class="col-lg-6">
		<div class="formrow">
		 <input type="text" class="form-control" name="location" id="location" placeholder="{{__('Location')}}" value="">
			</div>
	</div>
  <div class="col-lg-4" style="display: none;" id="second_location">
    <div class="formrow">
     <input type="text" class="form-control" name="flight_to" id="flight_to" placeholder="{{__('Flight To')}}" value="">
      </div>
  </div>
	<div class="col-lg-1">
		<div class="formbtn">
        <input type="submit" class="btn" value="{{__('Search')}}">
      </div>
	</div>
	</div>
	</form>
  </div>
</div>
<div class="parallax-section" id="hotels">
  <div class="container">
	  <div class="section-title">
      <h3>{{widget(5)->extra_field_1}} <span>{{widget(5)->extra_field_2}}</span></h3>
      <p>{{widget(5)->description}}</p>
    </div>
	 <div class="destinationList">
      <ul class="hotelslist hotelslider owl-carousel">
		@if(null!==(module(5))) 
        @foreach(module(5) as $hotel)
        <li class="item">
          <div class="locwrap">
            <div class="imgbox"><a href="{{asset('images/'.$hotel->image)}}" class="image-popup"><img src="{{asset('images/'.$hotel->image)}}" alt="" /></a></div>
            <h3>{{$hotel->title}}</h3>
            <div class="location"><i class="fa fa-map-marker" aria-hidden="true"></i> {{$hotel->extra_field_10}}</div>
			  <div class="prices"><span>{{__('Price')}}</span> {{$hotel->extra_field_1}}</div>
            <div class="meta">
				<span title="{{__('Hotel Type')}}"><i class="fa fa-hotel" aria-hidden="true"></i> <strong>{{$hotel->extra_field_2}}</strong></span>
				<span title="{{__('People')}}"><i class="fa fa-users" aria-hidden="true"></i> <strong>{{$hotel->extra_field_11}}</strong></span>
				<span title="{{__('Room Type')}}"><i class="fa fa-bed" aria-hidden="true"></i> <strong>{{$hotel->extra_field_3}}</strong></span></div>  
            <div class="buttons"><a href="{{route('hotels.detail',$hotel->slug)}}" class="btn"><i class="fa fa-calendar" aria-hidden="true"></i> {{__('View Details')}} </a></div>
          </div>
        </li>
		@endforeach
        @endif
      </ul>
	  </div>
  </div>
</div>
<!-- Service 1 -->
<div class="servicesbox bg1" style="background: url({{asset('images/'.widget(6)->extra_image_1)}})">
  <div class="container"> 
	 <div class="row">
		 <div class="col-md-6">
        <h3>{{widget(6)->extra_field_1}}</h3>
        <div class="ctoggle">
          <p>{{widget(6)->description}}</p>
          <a href="{{widget(6)->extra_field_3}}" class="readmore">{{widget(6)->extra_field_2}} <i class="fa fa-long-arrow-right" aria-hidden="true"></i></a> </div>
      </div>
      <div class="col-md-6">
        <div class="videobox">
		<iframe src="{{widget(6)->extra_field_4}}" width="100%" height="320" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Flights -->
<div class="parallax-section" id="flights">
  <div class="container">
    <div class="section-title">
      <h3>{{widget(18)->extra_field_1}}</h3>
      <p>{{widget(18)->description}}</p>
    </div>	  
	 <div class="destinationList">
      <ul class="hotelslist flightslider owl-carousel">
		@if(null!==(module(10))) 
        @foreach(module(10) as $flight)
        <li class="item">
          <div class="locwrap">	
            <div class="imgbox"><a href="{{asset('images/'.$flight->image)}}" class="image-popup"><img src="{{asset('images/'.$flight->image)}}" alt="" /></a></div>
		<div class="flightinfo">
            <h3>{{$flight->title}}</h3>
            <div class="location"><i class="fa fa-calendar" aria-hidden="true"></i> {{$flight->extra_field_9}} - {{$flight->extra_field_10}}</div>
			  <div class="prices"><span>{{__('Price')}}</span> {{$flight->extra_field_1}}</div>
            <div class="meta">
				<span title="{{__('Airline')}}"><i class="fas fa-plane"></i> <strong>{{$flight->extra_field_2}}</strong></span>
				<span title="{{__('Flight Type')}}"><i class="fa fa-users" aria-hidden="true"></i> <strong>{{$flight->extra_field_3}}</strong></span>
				<span title="{{__('From')}}"><i class="fas fa-plane-departure"></i> <strong>{{$flight->extra_field_7}}</strong></span>
			  <span title="{{__('To')}}"><i class="fas fa-plane-arrival"></i> <strong>{{$flight->extra_field_8}}</strong></span>
			  </div>
            
            <div class="buttons"><a href="{{route('flights.detail',$flight->slug)}}" class="btn"><i class="fa fa-calendar" aria-hidden="true"></i> {{__('View Details')}} </a></div>
			</div>
			  
          </div>	
        </li>
		@endforeach
        @endif
      </ul>
    </div>
	  
	  
  </div>
</div>
<!-- Counter Section -->
<div id="counter" style="background: url({{asset('images/'.widget(8)->extra_image_1)}})">
  <div class="container">
    <div class="row">
      <div class="col-md-3 col-sm-3 col-xs-12 counter-item">
        <div class="counterbox">
          <div class="counter-icon"><i class="fa fa-users" aria-hidden="true"></i></div>
          <span class="counter-number" data-from="1" data-to="{{widget(8)->extra_field_2}}" data-speed="1000"></span> <span class="counter-text">{{widget(8)->extra_field_1}}</span> </div>
      </div>
      <div class="col-md-3 col-sm-3 col-xs-12 counter-item">
        <div class="counterbox">
          <div class="counter-icon"><i class="fa fa-car" aria-hidden="true"></i></i></div>
          <span class="counter-number" data-from="1" data-to="{{widget(8)->extra_field_4}}" data-speed="2000"></span> <span class="counter-text">{{widget(8)->extra_field_3}}</span> </div>
      </div>
      <div class="col-md-3 col-sm-3 col-xs-12 counter-item">
        <div class="counterbox">
          <div class="counter-icon"><i class="fa fa-map-signs" aria-hidden="true"></i></div>
          <span class="counter-number" data-from="1" data-to="{{widget(8)->extra_field_6}}" data-speed="3000"></span> <span class="counter-text">{{widget(8)->extra_field_5}}</span> </div>
      </div>
      <div class="col-md-3 col-sm-3 col-xs-12 counter-item">
        <div class="counterbox">
          <div class="counter-icon"><i class="fa fa-trophy" aria-hidden="true"></i></div>
          <span class="counter-number" data-from="1" data-to="{{widget(8)->extra_field_8}}" data-speed="4000"></span> <span class="counter-text">{{widget(8)->extra_field_7}}</span> </div>
      </div>
    </div>
  </div>
</div>
<!-- About section -->
<div id="about">
  <div class="container">
    <div class="section-title">
      <h3>{!!removeTags(widget(7)->extra_field_1)!!}</h3>
      <p>{{widget(7)->extra_field_2}}</p>
    </div>
    <div class="about-desc">
      <div class="row">
        <div class="col-md-7">
        
          <p>{{widget(7)->description}}</p>
          <?php $bullets = json_decode(widget(7)->bullets); ?>
          <ul class="orderlist">
            @if(null!==($bullets))
            @foreach($bullets as $bullet)
            <li>{{$bullet->bullets}}</li>
            @endforeach
            @endif
          </ul>
        </div>
        <div class="col-md-5">
          <div class="postimg"><img src="{{asset('images/'.widget(7)->extra_image_1)}}"></div>
        </div>
      </div>
    </div>
	  
	
  </div>
</div>
<!-- Tagline Section -->
<div class="taglinewrap" style="background: url({{asset('images/'.widget(10)->extra_image_1)}})">
  <div class="container">
    <h2>{!!removeTags(widget(10)->extra_field_1)!!}</h2>
    <p>{!!removeTags(widget(10)->description)!!} </p>
    <a href="{!!removeTags(widget(10)->extra_field_3)!!}">{!!removeTags(widget(10)->extra_field_2)!!} <i class="fa fa-long-arrow-right" aria-hidden="true"></i></a> </div>
</div>
<!-- Service Section -->
<div id="service" class="parallax-section" >
  <div class="container"> 
    <!-- Section Title -->
    <div class="section-title" >
      <h3>{!!removeTags(widget(9)->extra_field_1)!!}</h3>
      <p>{{widget(9)->description}}</p>
    </div>
    <div class="row">
      @if(null!==(module(6))) 
      @foreach(module(6) as $service) 
      <div class="col-md-4 col-sm-6">
        <div class="service-thumb">
          <div class="thumb-icon">{!!removeTags($service->extra_field_1)!!}</div>
          <h4>{!!removeTags($service->title)!!}</h4>
          {!!removeTags($service->description)!!}
        </div>
      </div>
      @endforeach
      @endif
    </div>
  </div>
</div>
<!-- Team Section -->
<div id="team" class="parallax-section">
  <div class="container"> 
    <!-- Dection Title -->
    <div class="section-title" >
      <h3>{!!removeTags(widget(11)->extra_field_1)!!}</h3>
      <p>{!!removeTags(widget(11)->description)!!}</p>
    </div>
    <div class="row">
      @if(null!==(module(7))) 
      @foreach(module(7) as $expert)
      <div class="col-md-3 col-sm-6" >
        <div class="team-thumb">
          <div class="thumb-image"><img src="{{asset('images/'.$expert->image)}}" alt=""></div>
          <h4>{!!removeTags($expert->title)!!}</h4>
          <h5>{!!removeTags($expert->extra_field_1)!!}</h5>
          <div class="contct"><i class="fa fa-phone" aria-hidden="true"></i> {!!removeTags($expert->extra_field_2)!!}</div>
          <div class="contct"><i class="fa fa-envelope-o" aria-hidden="true"></i> {!!removeTags($expert->extra_field_3)!!}</div>
          <ul class="list-inline social">
            <li> <a href="{!!removeTags($expert->extra_field_4)!!}" class="bg-twitter"><i class="fab fa-twitter" aria-hidden="true"></i></a> </li>
            <li> <a href="{!!removeTags($expert->extra_field_5)!!}" class="bg-facebook"><i class="fab fa-facebook" aria-hidden="true"></i></a> </li>
            <li> <a href="{!!removeTags($expert->extra_field_6)!!}" class="bg-linkedin"><i class="fab fa-linkedin" aria-hidden="true"></i></a> </li>
          </ul>
        </div>
      </div>
      @endforeach
      @endif
    </div>
  </div>
</div>
<!-- Testimonials Section -->
<div id="testimonials" style="background: url({{asset('images/'.widget(12)->extra_image_1)}})">
  <div class="container"> 
    <!-- Section Title -->
    <div class="section-title">
      <h3>{!!removeTags(widget(12)->extra_field_1)!!}</h3>
    </div>
    <ul class="testimonialsList owl-carousel">
      @if(null!==(module(8))) 
      @foreach(module(8) as $testimoinial)
      <li class="item">
        <div class="rating"> 
          <?php if($testimoinial->extra_field_2 == 5){?>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
              <?php }else if($testimoinial->extra_field_2 == 4){ ?>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="far fa-star"></i>
              <?php }else if($testimoinial->extra_field_2 == 3){ ?>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
              <?php }else if($testimoinial->extra_field_2==2){ ?>
                  <i class="fa fa-star"></i>
                  <i class="fa fa-star"></i>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
              <?php }else if($testimoinial->extra_field_2==1){ ?>
                  <i class="fa fa-star"></i>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
              <?php }else if($testimoinial->extra_field_2==0){ ?>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
                  <i class="far fa-star"></i>
              <?php } ?>
         </div>
        {!!removeTags($testimoinial->description)!!}
        <div class="clientname">{{$testimoinial->title}}</div>
        <div class="clientinfo">{{$testimoinial->extra_field_1}}</div>
      </li>
      @endforeach
      @endif
    </ul>
  </div>
</div>
<div id="blog">
  <div class="container"> 
    <!-- SECTION TITLE -->
    <div class="section-title" >
      <h3>{!!removeTags(widget(13)->extra_field_1)!!}</h3>
      <p>{!!removeTags(widget(13)->description)!!}</p>
    </div>
    <ul class="hmblog owl-carousel">
      @if(null!==(module(3))) 
      @foreach(module(3) as $blog)
      <?php 
          $cate_ids = explode(",", $blog->category_ids);
          $categories = App\Models\ModulesData::whereIn('id', $cate_ids)->where('status','active')->get();
        $cate_array = array();
        foreach ($categories as $cat) {
            $cate_array[] = "<a href='" . route('blogs.list','cate='.$cat->id) . "'>$cat->title</a>";
        }  
      ?>
      <li class="item">
        <div class="mainblogpost">
          <div class="postimg"><img src="{{asset('images/'.$blog->image)}}" alt="{{$blog->title}}"> </div>
          <div class="postinfo">
            <div class="date"> <span>{{date('M d, Y',strtotime($blog->created_at))}}</span> </div>
            <h3><a href="{{route('blogs.detail',$blog->slug)}}">{{$blog->title}}</a></h3>
          </div>
        </div>
      </li>		
      @endforeach
      @endif
    </ul>
  </div>
</div>
<!-- Newsletter-->
<div class="newsletter">
  <div class="container">
    <div class="row">
      <div class="col-md-4">
        <h3>{!!removeTags(widget(14)->extra_field_1)!!}</h3>
        <p>{!!removeTags(widget(14)->description)!!}</p>
      </div>
      <div class="col-md-8">
         <form id="newsletter">
            @csrf
            <div class="input-group">
              <input type="text" class="form-control" name="email" id="email" placeholder="{{__('Enter Your Email Address')}}">
              <span class="input-group-btn">
              <button class="btn btn-secondary" type="submit">{{__('Sign Up')}} <i class="fa fa-paper-plane" aria-hidden="true"></i></button>
              </span> 
            </div>
          </form>
      </div>
    </div>
  </div>
</div>
<div id="map">
  <iframe src="https://maps.google.it/maps?q={{urlencode(strip_tags(widget(1)->extra_field_4))}}&output=embed" height="300" frameborder="0" allowfullscreen="" aria-hidden="false" tabindex="0"></iframe> 
</div>
<!-- Contact Section -->
<div id="contact">
  <div class="container"> 
    
    <!-- Dection Title -->
    <div class="section-title" >
      <h3>{!!removeTags(widget(15)->extra_field_1)!!}</h3>
      <p>{!!removeTags(widget(15)->description)!!}</p>
    </div>
    
    <!-- CONTACT FORM HERE -->
    <div class="row">
      <div class="col-md-8">
        <div class="contact-form">
          <form method="post" action="{{route('contact.post')}}" id="contactForm">
                @csrf
                <div class="row">
                  <div class="col-lg-6">
                      <input type="text" name="first_name" class="form-control" placeholder="{{__('First Name')}}" required="required">
                  </div>
                  <div class="col-lg-6">
                      <input type="text" name="last_name" class="form-control" placeholder="{{__('Last Name')}}" required="required">
                  </div>
                  <div class="col-lg-6">
                      <input type="email" name="email_address" class="form-control" placeholder="{{__('Email Address')}}" required="required">
                  </div>
                  <div class="col-lg-6">
                      <input type="text" name="phone_number" class="form-control" placeholder="{{__('Phone')}}" required="required">
                  </div>
                  <div class="col-lg-12">
                      <textarea required="required" class="form-control" name="message" placeholder="{{__('Message')}}"></textarea>
                  </div>
                  <div class="col-lg-12">
                    <div class="form-group">
                      <button id="submit" type="submit" class="form-control" name="submit">{{__('Send Message')}}</button>
                    </div>
                  </div>
                </div>
              </form>
          
        </div>
      </div>
      <div class="col-md-4">
        <div class="contact-now">
          <div class="contact"> <span><i class="fa fa-home"></i></span>
            <div class="information"> <strong>{{__('Address')}}:</strong>
              <p>{{widget(1)->extra_field_4}}</p>
            </div>
          </div>
          <!-- Contact Info -->
          <div class="contact"> <span><i class="fa fa-envelope"></i></span>
            <div class="information"> <strong>{{__('Email Address')}}:</strong>
              <p>{{widget(1)->extra_field_2}}</p>
            </div>
          </div>
          <!-- Contact Info -->
          <div class="contact"> <span><i class="fa fa-phone"></i></span>
            <div class="information"> <strong>{{__('Phone No')}}:</strong>
              <p>{{widget(1)->extra_field_3}}</p>
            </div>
          </div>
          <!-- Contact Info --> 
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Clients Logo-->
<div class="our-clients">
  <div class="container"> 
    
    <!-- Section Title -->
    <div class="section-title">
      <h3>{!!removeTags(widget(16)->extra_field_1)!!}</h3>
      <p>{!!removeTags(widget(16)->description)!!}</p>
    </div>
    <div class="owl-clients owl-carousel">
      @if(null!==(module(9))) 
      @foreach(module(9) as $partner)
      <div class="item"> <img src="{{asset('images/thumb/'.$partner->image)}}" alt=""> </div>
      @endforeach
      @endif
    </div>
  </div>
</div>
<!-- Clients Logo end--> 
 
@endsection
@push('js')
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key={{widget(17)->extra_field_1}}&libraries=places"></script>
<script type="text/javascript" src="{{asset('js/welcome.js')}}"></script>
<script type="text/javascript">
  var hotel_url = "{{route('hotels.list')}}";
  var flight_url = "{{route('flights.list')}}";
</script>
<script type="text/javascript" src="{{asset('js/search.js')}}"></script>
@if(session()->has('message.added'))
<script type="text/javascript">
  var msg = '{!! session('message.content' )!!}';
  var url = "{{route('newsletter.post')}}";
</script>
<script type="text/javascript" src="{{asset('js/order.js')}}"></script>
@endif
@endpush
