<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CKEditorController;
use App\Http\Controllers\FilerController;
use App\Http\Controllers\ClassesController;
use App\Http\Controllers\TeachersController;
use App\Http\Controllers\BlogsController;
use App\Http\Controllers\ContactusController;
use App\Http\Controllers\NewsLetterController;
use App\Http\Controllers\CmsController;
use App\Http\Controllers\TestimonialsController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\FbookingController;
use App\Http\Controllers\HotelsController;
use App\Http\Controllers\FlightsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


Route::post('ckeditor/upload',[CKEditorController::class, 'upload'])->name('ckeditor.image-upload');

Route::post('ajax_upload_file',[FilerController::class, 'upload'])->name('filer.image-upload');
Route::post('ajax_remove_file',[FilerController::class, 'fileDestroy'])->name('filer.image-remove');

/*Classes Start*/
Route::get('student/home',[ClassesController::class, 'index'])->name('student.home');
Route::get('classes',[ClassesController::class, 'index'])->name('classes.list');
Route::get('class/{slug}',[ClassesController::class, 'detail'])->name('classes.detail');

Route::get('testimonials',[TestimonialsController::class, 'index'])->name('testimonials.list');

/*End Classes*/

/*Teachers Start*/
Route::get('teachers',[TeachersController::class, 'index'])->name('teachers.list');
Route::get('teacher/{slug}',[TeachersController::class, 'detail'])->name('teachers.detail');

/*End Teachers*/

/*Blogs Start*/
Route::get('blog',[BlogsController::class, 'index'])->name('blogs.list');
Route::get('blog/{slug}',[BlogsController::class, 'detail'])->name('blogs.detail');

/*End Blogs*/

/*hotels Start*/
Route::get('hotels',[HotelsController::class, 'index'])->name('hotels.list');
Route::get('hotels/{slug}',[HotelsController::class, 'detail'])->name('hotels.detail');
/*End hotels*/

/*flights Start*/
Route::get('flights',[FlightsController::class, 'index'])->name('flights.list');
Route::get('flights/{slug}',[FlightsController::class, 'detail'])->name('flights.detail');
/*End flights*/

/*Contact Us Start*/
Route::get('contact-us',[ContactusController::class, 'index'])->name('contact.index');
Route::post('contact-us',[ContactusController::class, 'store'])->name('contact.post');

Route::post('booking',[BookingController::class, 'store'])->name('booking.post');
Route::post('flight-booking',[FbookingController::class, 'store'])->name('flightbooking.post');

Route::post('news-letter',[NewsLetterController::class, 'store'])->name('newsletter.post');

/*End Contact Us*/

Route::get('/{slug}',[CmsController::class, 'index'])->name('cms.page');

